from openai import OpenAI
import base64
import os
import time

os.environ["OPENAI_API_KEY"] = "sk-"

client=OpenAI()


def encode_image(image_path):
  with open(image_path, "rb") as image_file:
    return base64.b64encode(image_file.read()).decode('utf-8')


def chatgpt(image_path):
  base64_image = encode_image(image_path)
  completion =  client.chat.completions.create(
    model="gpt-4-vision-preview",
    messages=[
      {
        "role": "user",
        "content": [
          {"type": "text", "text": "Just describe the facial movements including Eyes, Nose, Lid, Lips, Lip Corner, Neck, Jaw, Tongue, Cheek, Mouth, Dimple, Chin and Eyebrow of the character in the photo."},
          {
            "type": "image_url",
            "image_url": {
              "url": f"data:image/jpeg;base64,{base64_image}",
            },
          },
        ],
      }
    ],
    max_tokens=200,
  )
  return completion.choices[0].message.content


if __name__ == "__main__": 
  ori = "/root/dataset/stressvideo/uvsd/mrf"
  videot = os.listdir(ori)
  for videos in videot:
      des_path=os.path.join("/root/dataset/stressvideo/uvsd/mrf_desc",videos)
      if not os.path.exists(des_path):  
          os.makedirs(des_path)
      ori_path=os.path.join(ori,videos)
      video=os.listdir(ori_path)
      for v in video:
          opath=os.path.join(ori_path,v) 
          dpath=os.path.join(des_path,v)   
          if not os.path.exists(dpath):  
              os.makedirs(dpath) 
          o_stress=os.listdir(opath)    
          for v_sub in os.listdir(opath):
              opath_sub=os.path.join(opath,"emo") 
              o_emo=os.listdir(opath_sub) 
              # dpath_sub=os.path.join(dpath,v_sub)   
              if os.path.exists(opath_sub):#存在emo             
                if not os.path.exists(os.path.join(dpath,"chatgpt_response")):
                  os.makedirs(os.path.join(dpath,"chatgpt_response"))                   
                emos = [os.path.join(opath_sub, frame) for frame in o_emo]                            
                for emo in emos: 
                  chatgpt_response=os.path.join(dpath,"chatgpt_response")+'\\'+os.path.basename(emo)[:-3]+"txt"       
                  time.sleep(5)
                  txt=chatgpt(emo)
                  with open(chatgpt_response, "w") as file:
                      file.write(txt)
                                      
                    
  print("finish")
